/*--------------------------------------------------------------------------*\

    FILE....: vpbio.h
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 20/12/01

    This file defines the interface between the FreeBSD kernel mode 
    device driver and the user mode driver code.  This interface
    supports the PCI cards.
	
\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef SYS_VPBIO_H
#define SYS_VPBIO_H

#ifndef KERNEL
#include <sys/types.h>
#endif
#include <sys/ioccom.h>

typedef struct {
  unsigned short port;
  unsigned short *data;
  int            length;
  int            dsp_addr;
  int            pci_num;
} VPB_DATA;

#define	VPB_IOC_MAGIC	'v'

#define VPB_IOC_PCI_BLOCK_WRITE    _IOW(VPB_IOC_MAGIC, 5, VPB_DATA)
#define VPB_IOC_PCI_BLOCK_READ     _IOW(VPB_IOC_MAGIC, 6, VPB_DATA)
#define VPB_IOC_PCI_DSP_RESET      _IOW(VPB_IOC_MAGIC, 7, VPB_DATA)
#define VPB_IOC_PCI_DSP_RUN        _IOW(VPB_IOC_MAGIC, 8, VPB_DATA)
#define VPB_IOC_PCI_GET_NUM_CARDS  _IOW(VPB_IOC_MAGIC, 9, VPB_DATA)

#endif
